local white = rgb(1,1,1)

-- ==============================
-- GEAR TABLE (USED FOR IMAGE LOGIC)
-- ==============================
local gearT = {
    [-1] = "R",
    [0]  = "N",
    [1]  = "1",
    [2]  = "2",
    [3]  = "3",
    [4]  = "4",
    [5]  = "5",
    [6]  = "6",
    [7]  = "7",
    [8]  = "8"
}

-- ==============================
-- DECIMALS
-- ==============================
local SESSION_KM_DECIMALS = 1
local TEMP_DECIMALS       = 1

-- ==============================
-- SPACING CONTROLS
-- ==============================
local KM_INT_X = 0
local KM_DOT_X = 24
local KM_DEC_X = 45

local TEMP_INT_X = 0
local TEMP_DOT_X = 225
local TEMP_DEC_X = 30

-- ==============================
-- GEAR MODE IMAGES
-- ==============================
local GEAR_IMG_DRIVE   = "./cluster/Cluster_Gear_D.png"
local GEAR_IMG_NEUTRAL = "./cluster/Cluster_Gear_N.png"
local GEAR_IMG_REVERSE = "./cluster/Cluster_Gear_R.png"

-- Shared size + opacity
local GEAR_SIZE  = vec2(46, 49)
local GEAR_COLOR = rgbm(1,1,1,1)

-- Individual positions
local GEAR_D_POS = vec2(1031, 1184)
local GEAR_N_POS = vec2(983, 1184)
local GEAR_R_POS = vec2(930, 1184)

-- ==============================
-- Helper
-- ==============================
local function splitFloat(value, decimals)
  local fmt = "%." .. decimals .. "f"
  local s = string.format(fmt, value)
  local int, dec = s:match("([^%.]+)%.?(.*)")
  if dec == nil then dec = "" end
  return int, dec
end

function update(dt)

  ------------------------------------------------
  -- GEAR IMAGE DRAW (USING gearT MAPPING)
  ------------------------------------------------
  local g = car.gear

  -- Convert numeric gear to label using your table:
  -- label is "R", "N", "1", "2", etc.
  local label = gearT[g]

  -- Fallbacks if the car reports something outside your table:
  --   - any negative gear -> "R"
  --   - zero -> "N"
  --   - any positive -> "1" (treated as Drive)
  if label == nil then
    if g < 0 then label = "R"
    elseif g == 0 then label = "N"
    elseif g > 0 then label = "1"
    end
  end

  -- Now pick texture by label (this is the important part)
  if label == "R" then
    ui.drawImage(
      GEAR_IMG_REVERSE,
      GEAR_R_POS,
      GEAR_R_POS + GEAR_SIZE,
      GEAR_COLOR
    )

  elseif label == "N" then
    ui.drawImage(
      GEAR_IMG_NEUTRAL,
      GEAR_N_POS,
      GEAR_N_POS + GEAR_SIZE,
      GEAR_COLOR
    )

  elseif label ~= nil then
    -- Any numeric label ("1".."8") = Drive image
    ui.drawImage(
      GEAR_IMG_DRIVE,
      GEAR_D_POS,
      GEAR_D_POS + GEAR_SIZE,
      GEAR_COLOR
    )
  end

  ------------------------------------------------
  -- TEMPERATURE
  ------------------------------------------------
  local tInt, tDec = splitFloat(sim.ambientTemperature * 1.8 + 32, TEMP_DECIMALS)
  local tempBasePos = vec2(759, 1292)

  display.text({
    text = tInt,
    pos = tempBasePos + vec2(TEMP_INT_X, 0),
    letter = vec2(40,60),
    font = 'amg2',
    color = white,
    alignment = 1,
    width = 250,
    spacing = -14
  })

  display.text({
    text = ".",
    pos = tempBasePos + vec2(TEMP_DOT_X, 0),
    letter = vec2(40, 60),
    font = 'amg2',
    color = white,
    alignment = 250.0,
    width = 1,
    spacing = -14
  })

  display.text({
    text = tDec,
    pos = tempBasePos + vec2(TEMP_DEC_X, 0),
    letter = vec2(40,60),
    font = 'amg2',
    color = white,
    alignment = 1.0,
    width = 250,
    spacing = -14
  })

  ------------------------------------------------
  -- TOTAL KM
  ------------------------------------------------
  display.text({
    text = string.format("%01d", car.distanceDrivenTotalKm),
    pos = vec2(894, 1039),
    letter = vec2(40, 60),
    font = 'amg',
    color = white,
    alignment = 0.5,
    width = 250,
    spacing = -15
  })

  ------------------------------------------------
  -- SESSION KM
  ------------------------------------------------
  local kmInt, kmDec = splitFloat(car.distanceDrivenSessionKm, SESSION_KM_DECIMALS)
  local kmBasePos = vec2(875, 955)

  display.text({
    text = kmInt,
    pos = kmBasePos + vec2(KM_INT_X, 0),
    letter = vec2(40, 60),
    font = 'amg',
    color = white,
    alignment = .5,
    width = 250,
    spacing = -20
  })

  display.text({
    text = ".",
    pos = kmBasePos + vec2(KM_DOT_X, 0),
    letter = vec2(40, 60),
    font = 'amg',
    color = white,
    alignment = 0.5,
    width = 250,
    spacing = -20
  })

  display.text({
    text = kmDec,
    pos = kmBasePos + vec2(KM_DEC_X, 0),
    letter = vec2(40, 60),
    font = 'amg',
    color = white,
    alignment = 0.5,
    width = 250,
    spacing = -20
  })

  ------------------------------------------------
  -- TIME
  ------------------------------------------------
  display.text({
    text = string.format("%02d:%02d", sim.timeHours, sim.timeMinutes),
    pos = vec2(955, 1240),
    letter = vec2(40,60),
    font = 'amg2',
    color = white,
    alignment = 0.0,
    width = 0,
    spacing = -18
  })

end
