local gearT = {
    [-1] = "R",
    [0] = "N",
    [1] = "1",
    [2] = "2",
    [3] = "3",
    [4] = "4",
    [5] = "5",
    [6] = "6",
    [7] = "7",
    [8] = "8"
}

-- Bright "LED" color 
local ledColor = rgb(1, 0.85, 0.1)

-- Dim background (ghosted digit)
local dimColor = rgb(0.15, 0.15, 0.1)

-- Only this position is used (centered display)
local pos = vec2(37,428)
local size = vec2(190, 380)

function update(dt)
    local gear = car.gear
    local gearText = gearT[gear] or "?"

    -- Draw all possible gear symbols faintly behind (ghost effect)
    for _, text in pairs(gearT) do
        display.text({
            text = text,
            pos = pos,
            letter = size,
            font = 'pixelBig',
            color = dimColor,
            alignment = 0.5,
            width = 0,
            spacing = 1
        })
    end

    -- Draw active gear on top in bright LED color
    display.text({
        text = gearText,
        pos = pos,
        letter = size,
        font = 'pixelBig',
        color = ledColor,
        alignment = 0.5,
        width = 0,
        spacing = 1
    })
end
