--––––––––––––––––––––––––––––––––––––––––––––––––––––––––––
-- CONFIGURATION
--––––––––––––––––––––––––––––––––––––––––––––––––––––––––––
local REV_LIMITER    = 6500       -- RPM at which to show “SHIFT UP”
local REFRESH        = 0.05       -- seconds between RPM samples

--––––––––––––––––––––––––––––––––––––––––––––––––––––––––––
-- DEBUG OPTIONS
--––––––––––––––––––––––––––––––––––––––––––––––––––––––––––
local DEBUG_SHOW_SHIFT = false    -- true = always show “SHIFT UP” for sizing
local SHIFT_TEXT        = "SHIFT UP"
local SHIFT_LETTER      = vec2(55, 110)   -- width×height per character
local SHIFT_POS         = vec2(30, 145)    -- x=0 is screen center
local SHIFT_COLOR       = rgb(1, 0.01, 0)
local SHIFT_ALIGNMENT   = 0.5
local SHIFT_SPACING     = 0
-- auto‑compute a width just wide enough for the string
local SHIFT_WIDTH = SHIFT_LETTER.x * #SHIFT_TEXT

--––––––––––––––––––––––––––––––––––––––––––––––––––––––––––
-- STATE
--––––––––––––––––––––––––––––––––––––––––––––––––––––––––––
local displayedRPM = 0
local rpmTimer     = 0

local white = rgb(0.90, 1, 1)

--––––––––––––––––––––––––––––––––––––––––––––––––––––––––––
-- MAIN UPDATE LOOP
--––––––––––––––––––––––––––––––––––––––––––––––––––––––––––
function update(dt)
    -- 1) Accumulate time and sample RPM at a steady rate
    rpmTimer = rpmTimer + dt
    if rpmTimer >= REFRESH then
        displayedRPM = math.floor(car.rpm)
        rpmTimer     = rpmTimer - REFRESH
    end

    -- 2) Decide whether to show “SHIFT UP” or the RPM number
    local isShift = DEBUG_SHOW_SHIFT or (displayedRPM >= REV_LIMITER)

    if isShift then
        -- Draw “SHIFT UP” centered on‑screen
        display.text({
            text      = SHIFT_TEXT,
            pos       = SHIFT_POS,
            letter    = SHIFT_LETTER,
            font      = 'fonts/m4_font',
            color     = SHIFT_COLOR,
            alignment = SHIFT_ALIGNMENT,
            width     = SHIFT_WIDTH,
            spacing   = SHIFT_SPACING,
        })
    else
        -- Draw the current RPM in white
        display.text({
            text      = displayedRPM,
            pos       = vec2(-35, 110),
            letter    = vec2(80, 160),
            font      = 'fonts/c7_big',
            color     = white,
            alignment = 0.5,
            width     = 555,
            spacing   = 1,
        })
    end
end
