local gearT = {
    [-1] = "R",
    [0] = "N",
    [1] = "1",
    [2] = "2",
    [3] = "3",
    [4] = "4",
    [5] = "5",
    [6] = "6",
    [7] = "7",
    [8] = "8"
}

local white = rgb(1, 1, 1)

-- Debug settings
local debugMode = false           -- Simulated speed
local debugDistance = false       -- Simulated km from speed
local simulatedSpeedKmh = 520

-- Refresh settings
local REFRESH = 0.2
local refreshTimer = 0

-- Distance tracking for debug
local simulatedSessionKm = 2510
local simulatedTotalKm = 2550

-- Cache for display values
local cached = {}

function getSpeedKmh()
    return debugMode and simulatedSpeedKmh or car.speedKmh
end

function update(dt)
    local speedKmh = getSpeedKmh()

    -- Simulate distance based on speed * dt
    if debugDistance then
        local distKm = (speedKmh / 3600) * dt
        simulatedSessionKm = simulatedSessionKm + distKm
        simulatedTotalKm = simulatedTotalKm + distKm
    end

    refreshTimer = refreshTimer - dt
    if refreshTimer <= 0 then
        refreshTimer = REFRESH

        local speedMph = math.floor(speedKmh / 1.609344)
        cached.time = string.format("%02d:%02d", sim.timeHours, sim.timeMinutes)
        cached.speed = speedMph

        if debugDistance then
            cached.totalKm = string.format("%02d", simulatedTotalKm)
            cached.sessionKm = string.format("%02d", simulatedSessionKm)
        else
            cached.totalKm = string.format("%02d", car.distanceDrivenTotalKm)
            cached.sessionKm = string.format("%02d", car.distanceDrivenSessionKm)
        end

        cached.temp = string.format("%02d", sim.ambientTemperature)
        cached.fuel = math.floor(car.fuel)
        cached.gear = gearT[car.gear]
    end

    display.text({ text = cached.time, pos = vec2(1011.5, 1350.7), letter = vec2(25, 60), font = 'e92_big', color = white, alignment = 0.9, width = 0, spacing = 1 })
    display.text({ text = cached.speed, pos = vec2(907.3, 1134.9), letter = vec2(55, 90), font = 'm4_font', color = white, alignment = 1, width = 255, spacing = -3 })
    display.text({ text = cached.totalKm, pos = vec2(1073, 1035), letter = vec2(29.5, 45), font = 'fonts/profec', color = white, alignment = 1, width = 250, spacing = -1})
    display.text({ text = cached.sessionKm, pos = vec2(1073, 999), letter = vec2(29.5, 45), font = 'fonts/profec', color = white, alignment = 1, width = 250, spacing = -1})
    display.text({ text = cached.temp, pos = vec2(1304.6, 1350.3), letter = vec2(25, 60), font = 'e92_big', color = white, alignment = 0.0, width = 0, spacing = 0 })
    display.text({ text = "F", pos = vec2(1364.6, 1350.3), letter = vec2(20, 60), font = 'e92_big', color = white, alignment = 0.0, width = 0, spacing = 0 })
    display.text({ text = cached.fuel, pos = vec2(1750, 1760), letter = vec2(25, 50), font = 'audi_vln_hd', color = white, alignment = 0.5, width = 255, spacing = 1 })
    display.text({ text = cached.gear, pos = vec2(1545.9, 712.8), letter = vec2(80, 150), font = 'digital_big', color = white, alignment = 0.5, width = 0, spacing = 1 })
end
